/*
 * Decompiled with CFR 0.152.
 */
package cons.sg.strcons;

import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class StringUtil {
    private static Logger logger = Logger.getLogger((String)StringUtil.class.getName());
    public static Properties ACCRONYM_MAP1 = new Properties();

    public static boolean isNullOrEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().equals("");
    }

    public static boolean isNotNullOrEmpty(String string) {
        return !StringUtil.isNullOrEmpty(string);
    }

    public static String convertToJavaVarCase(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            return string;
        }
        String string2 = "" + string.charAt(0);
        String string3 = "";
        if (string.length() == 1) {
            return string2.toLowerCase();
        }
        string3 = string2.toLowerCase() + string.substring(1);
        return string3;
    }

    public static String getTrimedValue(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String getTrimedValOrZeor(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            return "0";
        }
        return string.trim();
    }

    public static double convertToDouble(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static String convertAttrNameToPhrase(String string) {
        String string2 = "";
        if (StringUtil.isNullOrEmpty(string)) {
            return string;
        }
        int n = string.indexOf("@");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = c >= 'A' && c <= '[' ? string2 + " " + c : string2 + c;
        }
        return string2;
    }

    public static boolean isAllUpperCase(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= '[') continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isAllLowerCase(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < 'A' || c > '[') continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String replaceLast(String string, String string2, String string3) {
        String string4 = "";
        String string5 = string.trim() + " ";
        String string6 = string2.trim() + " ";
        string4 = string5.replaceAll(string6, string3);
        return string4;
    }

    public static String getConvertedVarNameInXMLCase(String string) {
        if (string == null) {
            string = "";
        }
        if (string.trim().equals("")) {
            return string;
        }
        String string2 = "" + string.charAt(0);
        String string3 = "";
        if (string.length() == 1) {
            return string2.toLowerCase();
        }
        string3 = string2.toUpperCase() + string.substring(1);
        return string3;
    }

    public static String getConvertedVarNameInJavaCase(String string) {
        if (string == null) {
            string = "";
        }
        if (string.trim().equals("")) {
            return string;
        }
        String string2 = "" + string.charAt(0);
        String string3 = "";
        if (string.length() == 1) {
            return string2.toLowerCase();
        }
        string3 = string2.toLowerCase() + string.substring(1);
        return string3;
    }

    public static String getDescription(String string) {
        return StringUtil.convertToDescription(string);
    }

    public static String getDescriptionForHtml(String string) {
        String string2 = StringUtil.convertToDescription(string);
        return string2.replaceAll(" ", "&nbsp;");
    }

    public static String convertToDescription(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        if (string.trim().equals("")) {
            return string;
        }
        String string2 = "";
        if (StringUtil.isNullOrEmpty(string)) {
            return string;
        }
        int n2 = string.indexOf("@");
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n >= 65 && n <= 91) {
                char c;
                string2 = string2 + " " + (char)n;
                boolean bl = false;
                if (i + 1 < string.length() && (c = string.charAt(i + 1)) >= 'A' && c <= '[') {
                    string2 = string2 + c;
                    ++i;
                    bl = true;
                }
                if (i + 1 < string.length() && (c = string.charAt(i + 1)) >= 'A' && c <= '[') {
                    string2 = string2 + c;
                    bl = true;
                    ++i;
                }
                if (i + 1 < string.length() && (c = string.charAt(i + 1)) >= 'A' && c <= '[') {
                    string2 = string2 + c;
                    bl = true;
                    ++i;
                }
                if (i + 1 < string.length() && (c = string.charAt(i + 1)) >= 'A' && c <= '[') {
                    string2 = string2 + c;
                    bl = true;
                    ++i;
                }
                if (i + 1 < string.length()) {
                    c = string.charAt(i + 1);
                    if (string2.trim().length() > 1 && string2.charAt(string2.length() - 2) != ' ' && (c < 'A' || c > '[')) {
                        string2 = string2.substring(0, string2.length() - 1);
                        logger.info((Object)("=====phrase========" + string2));
                        --i;
                    }
                }
                if (!bl) continue;
                string2 = string2 + " ";
                continue;
            }
            string2 = string2 + (char)n;
        }
        string2 = " " + string2 + " ";
        string2 = string2.replaceAll(" app ", " application ");
        string2 = string2.replaceAll(" App ", " application ");
        string2 = string2.replaceAll(" abcdef ", "  ");
        string2 = string2.replaceAll(" abcdef ", "  ");
        string2 = string2.replaceAll(".java ", " ");
        string2 = string2.replaceAll(".Java ", " ");
        string2 = string2.replaceAll(" Cust ", " Customer ");
        string2 = string2.replaceAll(" Pickd ", " Picked ");
        string2 = string2.replaceAll(" TO ", " Transfer Order ");
        string2 = string2.replaceAll(" SO ", " Sales Order ");
        string2 = string2.replaceAll(" Req ", " Request ");
        string2 = string2.replaceAll(" Ord ", " Order ");
        string2 = string2.replaceAll(" Shpmt ", " Shipment ");
        string2 = string2.replaceAll(" Rel ", " Release ");
        string2 = string2.replaceAll(" Inp ", "  Input ");
        string2 = string2.replaceAll(" Doc ", "  Document ");
        string2 = string2.replaceAll(" Out ", "  Output ");
        string2 = string2.replaceAll(" msg ", " message ");
        string2 = string2.replaceAll(" Msg ", " Message ");
        string2 = string2.replaceAll(" env ", " yfs environment ");
        string2 = string2.replaceAll(" Env ", " yfs Environment ");
        string2 = string2.replaceAll(" set ", " sets the ");
        string2 = string2.replaceAll(" get ", " gets the ");
        string2 = string2.replaceAll(" No ", " Number ");
        string2 = string2.replaceAll(" Id ", " Identifier ");
        string2 = string2.replaceAll(" ID ", " Identifier ");
        if ((string2 = string2.replaceAll(" UOM ", " Unit of measure")).endsWith(" Qty ")) {
            string2 = string2.replaceAll(" Qty ", " Quantity ");
        }
        if (string2.endsWith(" PO ")) {
            string2 = string2.replaceAll(" PO ", " purchase order number ");
        }
        if (string2.endsWith(" Desc ")) {
            string2 = string2.replaceAll(" Desc ", " description ");
        }
        if (string2.startsWith("Extn ")) {
            string2 = string2.replaceAll("Extn ", "Extension ");
        }
        if (string2.equals(" Extn ")) {
            string2 = string2.replaceAll(" Extn ", " Extension ");
        }
        logger.info((Object)("ACCRONYM_MAP=|" + ACCRONYM_MAP1.size() + "|"));
        String string3 = ACCRONYM_MAP1.getProperty(string2);
        if (string3 != null && (n = string2.lastIndexOf(32)) >= 0) {
            String string4 = string2.substring(n);
            logger.info((Object)("Val=|" + string4 + "|"));
            string2 = string2.replaceAll(string4, string3);
        }
        string2 = StringUtil.convertToSentenseCase(string2);
        return string2;
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }

    public static String convertToSentenseCase(String string) {
        logger.info((Object)("phrase=" + string));
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            String string3 = stringTokenizer.nextToken();
            if (string3.isEmpty()) continue;
            if (StringUtil.isAllUpperCase(string3)) {
                string2 = string2 + " " + string3;
                continue;
            }
            if (n == 1) {
                string2 = string2 + StringUtil.getConvertedVarNameInXMLCase(string3);
                continue;
            }
            string2 = string2 + " " + StringUtil.getConvertedVarNameInJavaCase(string3);
        }
        logger.info((Object)("sentensePhrase=" + string2));
        return string2;
    }

    public static boolean parentNameStartsWithChildName(String string, String string2) {
        int n;
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (string.indexOf("" + cArray[n]) < 0) continue;
            ++n2;
        }
        n = string2.length() - n2;
        if (n <= 1) {
            bl = true;
        }
        System.out.println("pelementName=" + string + "||childElmName=" + string2 + "|ret=" + bl + "|diff=" + n);
        return bl;
    }

    public static String getConstantName(String string) {
        String string2 = "";
        String string3 = string.replace(":", "");
        String string4 = "";
        String string5 = "";
        if (string3 == null) {
            return string3;
        }
        string3 = string3.replace("\"", "");
        string3 = string3.replace("/", "");
        for (int i = 0; i < string3.length(); ++i) {
            String string6 = "" + string3.charAt(i);
            if (i > 0 && string6.equals(string6.toUpperCase())) {
                string6 = "_" + string6;
            }
            string2 = string2 + string6.toUpperCase();
        }
        if (string.startsWith("/")) {
            string2 = string2 + "_XPATH";
        }
        return string5 + string2 + string4;
    }
}

